/* 
 * alarm.c 
 *
 * В циклі запускає таймер, виводить запит до користувача і протягом
 * певного часу (TIMEOUT) чекає від нього відповіді. По приходу 
 * сигналу SIGALRM припиняє чекання.
 * Ілюструє порядок застосування сигналу SIGALRM для асинхронного
 * вимірювання часових інтервалів.
 *
 */

#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

volatile sig_atomic_t alarmed = 0;


/* Обробник сигналу SIGALRM */
void onalarm(int signum) 
{
        alarmed++;
}

int main()
{
        enum {TIMEOUT = 5, BUFSIZE = 80};
        char buf[BUFSIZE];			
        struct sigaction act, oact;	

        /* Визначає нову диспозицію для сигналу SIGALRM. */
        memset(&act, 0, sizeof(act));
        act.sa_handler = onalarm;
#if 0
        act.sa_flags = SA_RESTART;
#endif
        if (sigaction(SIGALRM, &act, &oact) != 0) {
                fprintf(stderr, "Error setting action for SIGALRM: %s\n",
                                                        strerror(errno));
                exit(EXIT_FAILURE);
        }

        do {
                /* Зкидає прапорець, що сигналізує про надходження сигналу
                   SIGALRM. */
                alarmed = 0;
                /* Запускає таймер. */
                alarm(TIMEOUT);
                /* Виводить користувачу запит на введення даних. */
                printf("Enter me, please: ");
                /* Запам'ятовує введення користувача в буфері. */
                fgets(buf, BUFSIZE, stdin);
                /* Аналізує причину завершення fgets(). */
                if (alarmed) {
                        /* Витік тайм-аут. */
                        printf("\nBuka!\n");
                } else {
                        /* Тайм-аут не витік. 
                           Нижня половина обробника сигналу SIGALRM.
                           Зупиняє таймер. */
                        alarm(0);
                        printf("Thank you very much!\n");
                }
                /* Виводить користувачу запит на підтвердження продовження
                   роботи. */
                printf("One more time? [y/n] ");
                fgets(buf, BUFSIZE, stdin);
        } while (buf[0] == 'y' || buf[0] == 'Y'); 

        /* Відновлєю обробник сигналу SIGALRM. */
        if (sigaction(SIGALRM, &oact, NULL) != 0) {
                fprintf(stderr, "Error restoring action for SIGALRM:"
                                        " %s.\n", strerror(errno));
                exit(EXIT_FAILURE);
        }

        exit(EXIT_SUCCESS);
}
